/*
Template Name: HUD - Responsive Bootstrap 5 Admin Template
Version: 1.7.0
Author: Sean Ngu
Website: http://www.seantheme.com/hud/
	----------------------------
		APPS CONTENT TABLE
	----------------------------

	<!-- ======== GLOBAL SCRIPT SETTING ======== -->
  01. Global Variable
  02. Handle Scrollbar
  03. Handle Sidebar Menu
  04. Handle Sidebar Scroll Memory
  05. Handle Card Action
  06. Handle Tooltip & Popover Activation
  07. Handle Scroll to Top Button
  08. Handle hexToRgba
  09. Handle Scroll To
  10. Handle Toggle Class
  11. Handle Theme Panel
  12. Application Controller
  13. Initialise
	
	<!-- ======== APPLICATION SETTING ======== -->
	Application Controller
*/



/* 01. Global Variable
------------------------------------------------ */
var app = {
	id: '#app',
	isMobile: ((/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) || window.innerWidth < 992),
	bootstrap: {
		tooltip: {
			attr: 'data-bs-toggle="tooltip"'
		},
		popover: {
			attr: 'data-bs-toggle="popover"'
		},
		modal: {
			attr: 'data-bs-toggle="modal"',
			dismissAttr: 'data-bs-dismiss="modal"',
			event: {
				hidden: 'hidden.bs.modal'
			}
		},
		nav: {
			class: 'nav',
			tabs: {
				class: 'nav-tabs',
				activeClass: 'active',
				itemClass: 'nav-item',
				itemLinkClass: 'nav-link'
			}
		}
	},
	header: {
		id: '#header',
		class: 'app-header',
		hasScrollClass: 'has-scroll'
	},
	sidebar: {
		id: '#sidebar',
		class: 'app-sidebar',
		scrollBar: {
			localStorage: 'appSidebarScrollPosition',
			dom: ''
		},
		menu: {
			class: 'menu',
			initAttr: 'data-init',
			animationTime: 0,
			itemClass: 'menu-item',
			itemLinkClass: 'menu-link',
			hasSubClass: 'has-sub',
			activeClass: 'active',
			expandingClass: 'expanding',
			expandClass: 'expand',
			submenu: {
				class: 'menu-submenu',
			}
		},
		mobile: {
			toggleAttr: 'data-toggle="app-sidebar-mobile"',
			dismissAttr: 'data-dismiss="app-sidebar-mobile"',
			toggledClass: 'app-sidebar-mobile-toggled',
			closedClass: 'app-sidebar-mobile-closed',
			backdrop: {
				class: 'app-sidebar-mobile-backdrop'
			}
		},
		minify: {
			toggleAttr: 'data-toggle="app-sidebar-minify"',
			toggledClass: 'app-sidebar-minified',
			cookieName: 'app-sidebar-minified'
		},
		floatSubmenu: {
			id: '#app-sidebar-float-submenu',
			dom: '',
			timeout: '',
			class: 'app-sidebar-float-submenu',
			container: {
				class: 'app-sidebar-float-submenu-container'
			},
			arrow: {
				id: '#app-sidebar-float-submenu-arrow',
				class: 'app-sidebar-float-submenu-arrow'
			},
			line: {
				id: '#app-sidebar-float-submenu-line',
				class: 'app-sidebar-float-submenu-line'
			},
			overflow: {
				class: 'overflow-scroll mh-100vh'
			}
		},
		search: {
			class: 'menu-search',
			toggleAttr: 'data-sidebar-search="true"',
			hideClass: 'd-none',
			foundClass: 'has-text'
		},
		transparent: {
			class: 'app-sidebar-transparent'
		}
	},
	scrollBar: {
		attr: 'data-scrollbar="true"',
		skipMobileAttr: 'data-skip-mobile',
		heightAttr: 'data-height',
		wheelPropagationAttr: 'data-wheel-propagation'
	},
	content: {
		id: '#content',
		class: 'app-content',
		fullHeight: {
			class: 'app-content-full-height'
		},
		fullWidth: {
			class: 'app-content-full-width'
		}
	},
	layout: {
		sidebarLight: {
			class: 'app-with-light-sidebar'
		},
		sidebarEnd: {
			class: 'app-with-end-sidebar'
		},
		sidebarWide: {
			class: 'app-with-wide-sidebar'
		},
		sidebarMinified: {
			class: 'app-sidebar-minified'
		},
		sidebarTwo: {
			class: 'app-with-two-sidebar'
		},
		withoutHeader: {
			class: 'app-without-header'
		},
		withoutSidebar: {
			class: 'app-without-sidebar'
		},
		topMenu: {
			class: 'app-with-top-menu'
		},
		boxedLayout: {
			class: 'boxed-layout'
		}
	},
	scrollToTopBtn: {
		showClass: 'show',
		heightShow: 200,
		toggleAttr: 'data-toggle="scroll-to-top"',
		scrollSpeed: 500
	},
	scrollTo: {
		attr: 'data-toggle="scroll-to"',
		target: 'data-target',
		linkTarget: 'href'
	},
	themePanel: {
		class: 'app-theme-panel',
		toggleAttr: 'data-toggle="theme-panel-expand"',
		cookieName: 'app-theme-panel-expand',
		activeClass: 'active',
		themeListCLass: 'app-theme-list',
		themeListItemCLass: 'app-theme-list-item',
		themeCoverClass: 'app-theme-cover',
		themeCoverItemClass: 'app-theme-cover-item',
		theme: {
			toggleAttr: 'data-toggle="theme-selector"',
			classAttr: 'data-theme-class',
			cookieName: 'app-theme',
			activeClass: 'active'
		},
		themeCover: {
			toggleAttr: 'data-toggle="theme-cover-selector"',
			classAttr: 'data-theme-cover-class',
			cookieName: 'app-theme-cover',
			activeClass: 'active'
		}
	},
	dismissClass: {
		toggleAttr: 'data-dismiss-class',
		targetAttr: 'data-dismiss-target'
	},
	toggleClass: {
		toggleAttr: 'data-toggle-class',
		targetAttr: 'data-toggle-target'
	},
	font: {
		family: (getComputedStyle(document.body).getPropertyValue('--bs-body-font-family')).trim(),
		size: (getComputedStyle(document.body).getPropertyValue('--bs-body-font-size')).trim(),
		weight: (getComputedStyle(document.body).getPropertyValue('--bs-body-font-weight')).trim()
	},
	color: {
		theme: (getComputedStyle(document.body).getPropertyValue('--bs-theme')).trim(),
		blue: (getComputedStyle(document.body).getPropertyValue('--bs-blue')).trim(),
		green: (getComputedStyle(document.body).getPropertyValue('--bs-green')).trim(),
		orange: (getComputedStyle(document.body).getPropertyValue('--bs-orange')).trim(),
		red: (getComputedStyle(document.body).getPropertyValue('--bs-red')).trim(),
		cyan: (getComputedStyle(document.body).getPropertyValue('--bs-cyan')).trim(),
		purple: (getComputedStyle(document.body).getPropertyValue('--bs-purple')).trim(),
		yellow: (getComputedStyle(document.body).getPropertyValue('--bs-yellow')).trim(),
		indigo: (getComputedStyle(document.body).getPropertyValue('--bs-indigo')).trim(),
		pink: (getComputedStyle(document.body).getPropertyValue('--bs-pink')).trim(),
		black: (getComputedStyle(document.body).getPropertyValue('--bs-black')).trim(),
		white: (getComputedStyle(document.body).getPropertyValue('--bs-white')).trim(),
		gray: (getComputedStyle(document.body).getPropertyValue('--bs-gray')).trim(),
		dark: (getComputedStyle(document.body).getPropertyValue('--bs-dark')).trim(),
		gray100: (getComputedStyle(document.body).getPropertyValue('--bs-gray-100')).trim(),
		gray200: (getComputedStyle(document.body).getPropertyValue('--bs-gray-200')).trim(),
		gray300: (getComputedStyle(document.body).getPropertyValue('--bs-gray-300')).trim(),
		gray400: (getComputedStyle(document.body).getPropertyValue('--bs-gray-400')).trim(),
		gray500: (getComputedStyle(document.body).getPropertyValue('--bs-gray-500')).trim(),
		gray600: (getComputedStyle(document.body).getPropertyValue('--bs-gray-600')).trim(),
		gray700: (getComputedStyle(document.body).getPropertyValue('--bs-gray-700')).trim(),
		gray800: (getComputedStyle(document.body).getPropertyValue('--bs-gray-800')).trim(),
		gray900: (getComputedStyle(document.body).getPropertyValue('--bs-gray-900')).trim(),
		
		themeRgb: (getComputedStyle(document.body).getPropertyValue('--bs-theme-rgb')).trim(),
		blueRgb: (getComputedStyle(document.body).getPropertyValue('--bs-blue-rgb')).trim(),
		greenRgb: (getComputedStyle(document.body).getPropertyValue('--bs-green-rgb')).trim(),
		orangeRgb: (getComputedStyle(document.body).getPropertyValue('--bs-orange-rgb')).trim(),
		redRgb: (getComputedStyle(document.body).getPropertyValue('--bs-red-rgb')).trim(),
		cyanRgb: (getComputedStyle(document.body).getPropertyValue('--bs-cyan-rgb')).trim(),
		purpleRgb: (getComputedStyle(document.body).getPropertyValue('--bs-purple-rgb')).trim(),
		yellowRgb: (getComputedStyle(document.body).getPropertyValue('--bs-yellow-rgb')).trim(),
		indigoRgb: (getComputedStyle(document.body).getPropertyValue('--bs-indigo-rgb')).trim(),
		pinkRgb: (getComputedStyle(document.body).getPropertyValue('--bs-pink-rgb')).trim(),
		blackRgb: (getComputedStyle(document.body).getPropertyValue('--bs-black-rgb')).trim(),
		whiteRgb: (getComputedStyle(document.body).getPropertyValue('--bs-white-rgb')).trim(),
		grayRgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-rgb')).trim(),
		darkRgb: (getComputedStyle(document.body).getPropertyValue('--bs-dark-rgb')).trim(),
		gray100Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-100-rgb')).trim(),
		gray200Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-200-rgb')).trim(),
		gray300Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-300-rgb')).trim(),
		gray400Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-400-rgb')).trim(),
		gray500Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-500-rgb')).trim(),
		gray600Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-600-rgb')).trim(),
		gray700Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-700-rgb')).trim(),
		gray800Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-800-rgb')).trim(),
		gray900Rgb: (getComputedStyle(document.body).getPropertyValue('--bs-gray-900-rgb')).trim()
	},
	card: {
		expand: {
			status: false,
			toggleAttr: 'data-toggle="card-expand"',
			toggleTitle: 'Expand / Compress',
			class: 'card-expand'
		}
	},
	init: {
		attr: 'data-init'
	}
};



/* 02. Handle Scrollbar
------------------------------------------------ */
var handleScrollbar = function() {
	"use strict";
	var elms = document.querySelectorAll('['+ app.scrollBar.attr +']');
		
	for (var i = 0; i < elms.length; i++) {
		generateScrollbar(elms[i])
	}
};
var generateScrollbar = function(elm) {
  "use strict";
	
	if (elm.scrollbarInit || (app.isMobile && elm.getAttribute(app.scrollBar.skipMobileAttr))) {
		return;
	}
	var dataHeight = (!elm.getAttribute(app.scrollBar.heightAttr)) ? elm.offsetHeight : elm.getAttribute(app.scrollBar.heightAttr);
	
	elm.style.height = dataHeight;
	elm.scrollbarInit = true;
	
	if(app.isMobile) {
		elm.style.overflowX = 'scroll';
	} else {
		var dataWheelPropagation = (elm.getAttribute(app.scrollBar.wheelPropagationAttr)) ? elm.getAttribute(app.scrollBar.wheelPropagationAttr) : false;
		
		if (elm.closest('.'+ app.sidebar.class) && elm.closest('.'+ app.sidebar.class).length !== 0) {
			app.sidebar.scrollBar.dom = new PerfectScrollbar(elm, {
				wheelPropagation: dataWheelPropagation
			});
		} else {
			new PerfectScrollbar(elm, {
				wheelPropagation: dataWheelPropagation
			});
		}
	}
	elm.setAttribute(app.init.attr, true);
};



/* 03. Handle Sidebar Menu
------------------------------------------------ */
var handleSidebarMenuToggle = function(menus) {
	menus.map(function(menu) {
		menu.onclick = function(e) {
			e.preventDefault();
			var target = this.nextElementSibling;
	
			menus.map(function(m) {
				var otherTarget = m.nextElementSibling;
				if (otherTarget !== target) {
					otherTarget.style.display = 'none';
					otherTarget.closest('.'+ app.sidebar.menu.itemClass).classList.remove(app.sidebar.menu.expandClass);
				}
			});
	
			var targetItemElm = target.closest('.'+ app.sidebar.menu.itemClass);

			if (targetItemElm.classList.contains(app.sidebar.menu.expandClass) || (targetItemElm.classList.contains(app.sidebar.menu.activeClass) && !target.style.display)) {
				targetItemElm.classList.remove(app.sidebar.menu.expandClass);
				target.style.display = 'none';
			} else {
				targetItemElm.classList.add(app.sidebar.menu.expandClass);
				target.style.display = 'block';
			}
		}
	});
};
var handleSidebarMenu = function() {
	"use strict";
	
	var menuBaseSelector = '.'+ app.sidebar.class +' .'+ app.sidebar.menu.class +' > .'+ app.sidebar.menu.itemClass +'.'+ app.sidebar.menu.hasSubClass;
	var submenuBaseSelector = ' > .'+ app.sidebar.menu.submenu.class +' > .'+ app.sidebar.menu.itemClass + '.' + app.sidebar.menu.hasSubClass;
	
	// menu
	var menuLinkSelector =  menuBaseSelector + ' > .'+ app.sidebar.menu.itemLinkClass;
	var menus = [].slice.call(document.querySelectorAll(menuLinkSelector));
	handleSidebarMenuToggle(menus);
	
	// submenu lvl 1
	var submenuLvl1Selector = menuBaseSelector + submenuBaseSelector;
	var submenusLvl1 = [].slice.call(document.querySelectorAll(submenuLvl1Selector + ' > .' + app.sidebar.menu.itemLinkClass));
	handleSidebarMenuToggle(submenusLvl1);
	
	// submenu lvl 2
	var submenuLvl2Selector = menuBaseSelector + submenuBaseSelector + submenuBaseSelector;
	var submenusLvl2 = [].slice.call(document.querySelectorAll(submenuLvl2Selector + ' > .' + app.sidebar.menu.itemLinkClass));
	handleSidebarMenuToggle(submenusLvl2);
};



/* 04. Handle Sidebar Scroll Memory
------------------------------------------------ */
var handleSidebarScrollMemory = function() {
	if (!app.isMobile) {
		try {
			if (typeof(Storage) !== 'undefined' && typeof(localStorage) !== 'undefined') {
				var elm = document.querySelector('.'+ app.sidebar.class +' ['+ app.scrollBar.attr +']');
				
				if (elm) {
					elm.onscroll = function() {
						localStorage.setItem(app.sidebar.scrollBar.localStorage, this.scrollTop);
					}
					var defaultScroll = localStorage.getItem(app.sidebar.scrollBar.localStorage);
					if (defaultScroll) {
						document.querySelector('.'+ app.sidebar.class +' ['+ app.scrollBar.attr +']').scrollTop = defaultScroll;
					}
				}
			}
		} catch (error) {
			console.log(error);
		}
	}
};



/* 05. Handle Card Action
------------------------------------------------ */
var handleCardAction = function() {
	"use strict";

	if (app.card.expand.status) {
		return false;
	}
	app.card.expand.status = true;

	// expand
	var expandTogglerList = [].slice.call(document.querySelectorAll('['+ app.card.expand.toggleAttr +']'));
	var expandTogglerTooltipList = expandTogglerList.map(function (expandTogglerEl) {
		expandTogglerEl.onclick = function(e) {
			e.preventDefault();
		
			var target = this.closest('.card');
			var targetClass = app.card.expand.class;
			var targetTop = 40;

			if (document.body.classList.contains(targetClass) && target.classList.contains(targetClass)) {
				target.removeAttribute('style');
				target.classList.remove(targetClass);
				document.body.classList.remove(targetClass);
			} else {
				document.body.classList.add(targetClass);
				target.classList.add(targetClass);
			}
		
			window.dispatchEvent(new Event('resize'));
		};
	
		return new bootstrap.Tooltip(expandTogglerEl, {
			title: app.card.expand.toggleTitle,
			placement: 'bottom',
			trigger: 'hover',
			container: 'body'
		});
	});
};



/* 06. Handle Tooltip & Popover Activation
------------------------------------------------ */
var handelTooltipPopoverActivation = function() {
	"use strict";
	
	var tooltipTriggerList = [].slice.call(document.querySelectorAll('['+ app.bootstrap.tooltip.attr +']'))
	var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
		return new bootstrap.Tooltip(tooltipTriggerEl);
	});
	
	var popoverTriggerList = [].slice.call(document.querySelectorAll('['+ app.bootstrap.popover.attr +']'))
	var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
		return new bootstrap.Popover(popoverTriggerEl);
	});
};



/* 07. Handle Scroll to Top Button
------------------------------------------------ */
var handleScrollToTopButton = function() {
	"use strict";
	
	var elmTriggerList = [].slice.call(document.querySelectorAll('['+ app.scrollToTopBtn.toggleAttr +']'));
	
	document.onscroll = function() {
		var doc = document.documentElement;
		var totalScroll = (window.pageYOffset || doc.scrollTop)  - (doc.clientTop || 0);
		var elmList = elmTriggerList.map(function(elm) {
			if (totalScroll >= app.scrollToTopBtn.heightShow) {
				if (!elm.classList.contains(app.scrollToTopBtn.showClass)) {
					elm.classList.add(app.scrollToTopBtn.showClass);
				}
			} else {
				elm.classList.remove(app.scrollToTopBtn.showClass);
			}
		});
		
		var elm = document.querySelectorAll(app.id)[0];
	
		if (totalScroll > 0) {
			elm.classList.add(app.header.hasScrollClass);
		} else {
			elm.classList.remove(app.header.hasScrollClass);
		}
	}
	
	var elmList = elmTriggerList.map(function(elm) {
		elm.onclick = function(e) {
			e.preventDefault();
			
			window.scrollTo({top: 0, behavior: 'smooth'});
		}
	});
};



/* 08. Handle hexToRgba
------------------------------------------------ */
var hexToRgba = function(hex, transparent = 1) {
	var c;
	if(/^#([A-Fa-f0-9]{3}){1,2}$/.test(hex)){
		c= hex.substring(1).split('');
		if(c.length== 3){
				c= [c[0], c[0], c[1], c[1], c[2], c[2]];
		}
		c= '0x'+c.join('');
		return 'rgba('+[(c>>16)&255, (c>>8)&255, c&255].join(',')+','+ transparent +')';
	}
  throw new Error('Bad Hex');
};



/* 09. Handle Scroll To
------------------------------------------------ */
var handleScrollTo = function() {
	var elmTriggerList = [].slice.call(document.querySelectorAll('['+ app.scrollTo.attr +']'));
	var elmList = elmTriggerList.map(function(elm) {
		elm.onclick = function(e) {
			e.preventDefault();
		
			var targetAttr = (elm.getAttribute(app.scrollTo.target)) ? this.getAttribute(app.scrollTo.target) : this.getAttribute(app.scrollTo.linkTarget);
			var targetElm = document.querySelectorAll(targetAttr)[0];
			var targetHeader = document.querySelectorAll(app.header.id)[0];
			var targetHeight = targetHeader.offsetHeight;
			if (targetElm) {
				var targetTop = targetElm.offsetTop - targetHeight - 24;
				window.scrollTo({top: targetTop, behavior: 'smooth'});
			}
		}
	});
};



/* 10. Handle Toggle Class
------------------------------------------------ */
var handleToggleClass = function() {
	var elmList = [].slice.call(document.querySelectorAll('['+ app.toggleClass.toggleAttr +']'));
	
	elmList.map(function(elm) {
		elm.onclick = function(e) {
			e.preventDefault();
			
			var targetToggleClass = this.getAttribute(app.toggleClass.toggleAttr);
			var targetDismissClass = this.getAttribute(app.dismissClass.toggleAttr);
			var targetToggleElm = document.querySelector(this.getAttribute(app.toggleClass.targetAttr));
		
			if (!targetDismissClass) {
				if (targetToggleElm.classList.contains(targetToggleClass)) {
					targetToggleElm.classList.remove(targetToggleClass);
				} else {
					targetToggleElm.classList.add(targetToggleClass);
				}
			} else {
				if (!targetToggleElm.classList.contains(targetToggleClass) && !targetToggleElm.classList.contains(targetDismissClass)) {
					if (targetToggleElm.classList.contains(targetToggleClass)) {
						targetToggleElm.classList.remove(targetToggleClass);
					} else {
						targetToggleElm.classList.add(targetToggleClass);
					}
				} else {
					if (targetToggleElm.classList.contains(targetToggleClass)) {
						targetToggleElm.classList.remove(targetToggleClass);
					} else {
						targetToggleElm.classList.add(targetToggleClass);
					}
					if (targetToggleElm.classList.contains(targetDismissClass)) {
						targetToggleElm.classList.remove(targetDismissClass);
					} else {
						targetToggleElm.classList.add(targetDismissClass);
					}
				}
			}
		}
	});
}



/* 11. Handle Theme Panel
------------------------------------------------ */
var handleThemePanel = function() {
	"use strict";
	
	// 12.1 Theme Panel - Toggle / Dismiss
	var elmList = [].slice.call(document.querySelectorAll('['+ app.themePanel.toggleAttr +']'));
	
	elmList.map(function(elm) {
		elm.onclick = function(e) {
			e.preventDefault();
			
			var targetContainer = document.querySelector('.'+ app.themePanel.class);
			var targetExpand = false;
		
			if (targetContainer.classList.contains(app.themePanel.activeClass)) {
				targetContainer.classList.remove(app.themePanel.activeClass);
			} else {
				targetContainer.classList.add(app.themePanel.activeClass);
				targetExpand = true;
			}
			if (Cookies) {
				Cookies.set(app.themePanel.cookieName, targetExpand);
			}
		}
	});
	
	// 12.2 Theme Panel - Page Load Cookies 
	if (Cookies) {
		var themePanelExpand = Cookies.get(app.themePanel.cookieName);
		
		if (themePanelExpand == 'true' || typeof themePanelExpand == 'undefined') {
			var elm = document.querySelector('['+ app.themePanel.toggleAttr +']');
			if (elm) {
				elm.click();
			}
		}
	}
	
	
	// 12.3 Theme Panel - Theme Selector
	var elmList = [].slice.call(document.querySelectorAll('.'+ app.themePanel.class +' ['+ app.themePanel.theme.toggleAttr +']'));
	elmList.map(function(elm) {
		elm.onclick = function() {
			for (var x = 0; x < document.body.classList.length; x++) {
				var targetClass = document.body.classList[x];
				if (targetClass.search('theme-') > -1) {
					document.body.classList.remove(targetClass);
				}
			}
		
			var targetTheme = this.getAttribute(app.themePanel.theme.classAttr);
			var targetThemeList = [].slice.call(document.querySelectorAll('.'+ app.themePanel.class +' ['+ app.themePanel.theme.toggleAttr +']'));
			
			if (targetTheme) {
				document.body.classList.add(targetTheme);
			}
			targetThemeList.map(function(targetElm) {
				if (targetElm.getAttribute(app.themePanel.theme.classAttr) != targetTheme) {
					targetElm.closest('.'+ app.themePanel.themeListItemCLass).classList.remove(app.themePanel.theme.activeClass);
				}
			});
			
			this.closest('.'+ app.themePanel.themeListItemCLass).classList.add(app.themePanel.theme.activeClass);
			
			if (Cookies) {
				Cookies.set(app.themePanel.theme.cookieName, targetTheme);
				app.color.theme = (getComputedStyle(document.body).getPropertyValue('--bs-theme')).trim();
				app.color.themeRgb = (getComputedStyle(document.body).getPropertyValue('--bs-theme-rgb')).trim();
				
				document.dispatchEvent(new Event('theme-reload'));
			}
		}
	});
	
	if (Cookies) {
		if (Cookies.get(app.themePanel.theme.cookieName)) {
			var targetElm = document.querySelector('.'+ app.themePanel.class +' ['+ app.themePanel.theme.toggleAttr +']' + '['+ app.themePanel.theme.classAttr +'="'+ Cookies.get(app.themePanel.theme.cookieName) +'"]');
			targetElm.click();
			
			app.color.theme = (getComputedStyle(document.body).getPropertyValue('--bs-theme')).trim();
			app.color.themeRgb = (getComputedStyle(document.body).getPropertyValue('--bs-theme-rgb')).trim();
			
			document.dispatchEvent(new Event('theme-reload'));
		}
	}
	
	
	// 12.4 Theme Panel - Background Selector
	var elmList = [].slice.call(document.querySelectorAll('.'+ app.themePanel.class +' ['+ app.themePanel.themeCover.toggleAttr +']'));
	elmList.map(function(elm) {
		elm.onclick = function(e) {
			e.preventDefault();
			
			var htmlElm = document.querySelector('html');
			var targetTheme = this.getAttribute(app.themePanel.themeCover.classAttr);
			for (var x = 0; x < document.documentElement.classList.length; x++) {
				var targetClass = document.documentElement.classList[x];
				if (targetClass.search('bg-cover-') > -1) {
					htmlElm.classList.remove(targetClass);
				}
			}
			
			if (targetTheme) {
				htmlElm.classList.add(targetTheme);
			}
			
			var targetCoverList = [].slice.call(document.querySelectorAll('.'+ app.themePanel.class +' ['+ app.themePanel.themeCover.toggleAttr +']'));
			targetCoverList.map(function(targetElm) {
				if (targetElm.getAttribute(app.themePanel.themeCover.toggleAttr) != targetTheme) {
					targetElm.closest('.'+ app.themePanel.themeCoverItemClass).classList.remove(app.themePanel.themeCover.activeClass);
				}
			});
			
			this.closest('.'+ app.themePanel.themeCoverItemClass).classList.add(app.themePanel.themeCover.activeClass);
			if (Cookies) {
				Cookies.set(app.themePanel.themeCover.cookieName, targetTheme);
			}
		};
	});
	
	if (Cookies) {
		if (Cookies.get(app.themePanel.themeCover.cookieName)) {
			var targetElm = document.querySelector('.'+ app.themePanel.class +' ['+ app.themePanel.themeCover.toggleAttr +']' + '['+ app.themePanel.themeCover.classAttr +'="'+ Cookies.get(app.themePanel.themeCover.cookieName) +'"]');
			if (targetElm) {
				targetElm.click();
			}
		}
	}
};



/* 12. Application Controller
------------------------------------------------ */
var App = function () {
	"use strict";
	
	return {
		//main function
		init: function () {
			this.initComponent();
			this.initSidebar();
		},
		initSidebar: function() {
			handleSidebarMenu();
			handleSidebarScrollMemory();
		},
		initComponent: function() {
			handleScrollbar();
			handleScrollToTopButton();
			handleScrollTo();
			handleCardAction();
			handelTooltipPopoverActivation();
			handleToggleClass();
			handleThemePanel();
		},
		scrollTop: function() {
			window.scrollTo({top: 0, behavior: 'smooth'});
		}
	};
}();



/* 13. Initialise
------------------------------------------------ */
document.addEventListener('DOMContentLoaded', function() {
	App.init();
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
